# 퀵 셀렉트

### 문제

주어진 배열에 대해, k번째로 큰/작은 원소를 선형 시간복잡도 안에 찾아라.

### 접근

- 배열에서 무작위로 '피벗'으로 쓰일 원소를 정한다.
- 퀵 소트에서와 같이, 파티션을 적용한다.
- 파티션을 나누면, 피벗보다 작은 원소들은 피벗의 왼쪽 부분에 위치하고, 피벗보다 큰 원소들은 피벗의 오른쪽 부분에 위치하게 된다. 즉, 피벗은 배열 내에서 정렬된 위치에 존재한다.
- 피벗의 인덱스가 k라면, 원하는 원소를 찾았으므로 피벗을 반환한다.
- 아니라면, 현재 피벗의 위치가 k보다 큰지 작은지 확인하고, 이에 따라 k번째 원소가 위치할 수 있는 범위 안에서 새로운 피벗을 고른다. 
- 이를 반복한다.

### 시간 복잡도

- 최악의 경우 `O(n^2)`

- 최선의 경우 `O(n)`

- 평균 `O(n)`


### 알고리즘을 고안한 사람

- 이 알고리즘은 토니 호어(Tony Hoare)에 의해 발명되어, `호어의 선택 알고리즘`이라고도 불린다.

### 예시

```
배열 = {8,2,11,7,9,1,3}
인덱스: 0 1 2 3 4 5 6

k = 4, 즉 4번째로 작은 원소를 찾고 싶다고 하자.

1. 무작위로 피벗을 고른다. 여기서는 7을 골랐다고 하자.
2. 7과 마지막 원소(3)의 위치를 바꾸고, 파티션을 적용한다.
3. 그러면 7보다 작은 모든 원소들은 7의 왼쪽에 있고, 7보다 큰 모든 원소들은 7의 오른쪽에 있게 된다. 즉, 7은 정렬된 위치에 있다. (배열 = {2,3,1,7,8,9,11})
4. 7의 위치가 4번째이므로, 우리가 찾는 원소이다. 7을 반환한다.
```

### 구현

- [Java](https://github.com/TheAlgorithms/Java/blob/master/src/main/java/com/thealgorithms/searches/QuickSelect.java)
- [Python](https://github.com/TheAlgorithms/Python/blob/master/searches/quick_select.py)
- [Go](https://github.com/TheAlgorithms/Go/blob/master/search/selectk.go)
- [JavaScript](https://github.com/TheAlgorithms/JavaScript/blob/master/Data-Structures/Array/QuickSelect.js)

### 관련 영상

[여러가지 시간 복잡도에 따라 K번째로 작은/큰 원소를 찾는 방법을 설명하는 영상](https://youtu.be/hGK_5n81drs)
